/*
 * Decompiled with CFR 0.152.
 */
package wox.serial;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import wox.serial.EncodeBase64;
import wox.serial.ObjectReader;
import wox.serial.TypeMapping;
import wox.serial.Util;

public class SimpleReader
extends TypeMapping
implements ObjectReader {
    HashMap map = new HashMap();
    static HashMap primitivesMap = new HashMap();

    @Override
    public Object read(Element xob) {
        if (this.empty(xob)) {
            return null;
        }
        if (this.reference(xob)) {
            return this.map.get(xob.getAttributeValue("idref"));
        }
        Object ob = null;
        String id = xob.getAttributeValue("id");
        if (this.isPrimitiveArray(xob)) {
            ob = this.readPrimitiveArray(xob, id);
        } else if (this.isArray(xob)) {
            ob = this.readObjectArray(xob, id);
        } else if (this.isArrayList(xob)) {
            ob = this.readArrayList(xob, id);
        } else if (this.isHashMap(xob)) {
            System.out.println("readHashMap: " + xob.getAttributeValue("type"));
            ob = this.readHashMap(xob, id);
        } else {
            ob = Util.stringable(xob.getAttributeValue("type")) ? this.readStringObject(xob, id) : this.readObject(xob, id);
        }
        return ob;
    }

    private boolean empty(Element xob) {
        return !xob.getAttributes().iterator().hasNext() && !xob.getContent().iterator().hasNext();
    }

    private boolean reference(Element xob) {
        boolean ret = xob.getAttribute("idref") != null;
        return ret;
    }

    private boolean isPrimitiveArray(Element xob) {
        if (!xob.getAttributeValue("type").equals("array")) {
            return false;
        }
        String arrayType = xob.getAttributeValue("elementType");
        for (int i = 0; i < primitiveArraysWOX.length; ++i) {
            if (!primitiveArraysWOX[i].equals(arrayType)) continue;
            return true;
        }
        return false;
    }

    private boolean isArray(Element xob) {
        return xob.getAttributeValue("type").equals("array");
    }

    private boolean isArrayList(Element xob) {
        return xob.getAttributeValue("type").equals("list");
    }

    private boolean isHashMap(Element xob) {
        return xob.getAttributeValue("type").equals("map");
    }

    private Object readPrimitiveArray(Element xob, Object id) {
        try {
            Class type = (Class)mapWOXToJava.get(xob.getAttributeValue("elementType"));
            Class wrapperType = this.getWrapperType(type);
            Constructor cons = null;
            if (!(type.equals(Character.TYPE) || type.equals(Character.class) || type.equals(Class.class))) {
                cons = wrapperType.getDeclaredConstructor(String.class);
            }
            Object[] args = new Object[1];
            int len = Integer.parseInt(xob.getAttributeValue("length"));
            Object array = Array.newInstance(type, len);
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                Object byteArray = this.readByteArray(xob);
                if (type.equals(Byte.class)) {
                    byte[] arrayPrimitiveByte = (byte[])byteArray;
                    Byte[] arrayWrapperByte = new Byte[arrayPrimitiveByte.length];
                    for (int k = 0; k < arrayPrimitiveByte.length; ++k) {
                        arrayWrapperByte[k] = new Byte(arrayPrimitiveByte[k]);
                    }
                    this.map.put(id, arrayWrapperByte);
                    return arrayWrapperByte;
                }
                this.map.put(id, byteArray);
                return byteArray;
            }
            if (type.equals(Character.TYPE)) {
                Object charArray = this.readCharArray((char[])array, xob);
                this.map.put(id, charArray);
                return charArray;
            }
            if (type.equals(Character.class)) {
                Object charArray = this.readCharArray((Character[])array, xob);
                this.map.put(id, charArray);
                return charArray;
            }
            if (type.equals(Class.class)) {
                Object classArray = this.readClassArray((Class[])array, xob);
                this.map.put(id, classArray);
                return classArray;
            }
            StringTokenizer st = new StringTokenizer(xob.getText());
            int index = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.equals("null")) {
                    Array.set(array, index++, null);
                    continue;
                }
                args[0] = s;
                Object value = cons.newInstance(args);
                Array.set(array, index++, value);
            }
            this.map.put(id, array);
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Class getPrimitiveType(String name) {
        for (int i = 0; i < primitives.length; ++i) {
            if (!primitives[i].getName().equals(name)) continue;
            return primitives[i];
        }
        return null;
    }

    private Class getWrapperType(Class type) {
        for (int i = 0; i < primitives.length; ++i) {
            if (!primitives[i].equals(type)) continue;
            return primitiveWrappers[i];
        }
        return type;
    }

    private Class getWrapperType(String type) {
        for (int i = 0; i < primitives.length; ++i) {
            if (!primitives[i].getName().equals(type)) continue;
            return primitiveWrappers[i];
        }
        return null;
    }

    private Object readIntArray(int[] a, Element xob) {
        StringTokenizer st = new StringTokenizer(xob.getText());
        int index = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            a[index++] = Integer.parseInt(s);
        }
        return a;
    }

    private Object readIntArray(Integer[] a, Element xob) {
        StringTokenizer st = new StringTokenizer(xob.getText());
        int index = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("null")) {
                a[index++] = null;
                continue;
            }
            a[index++] = new Integer(s);
        }
        return a;
    }

    private Object readByteArray(Element xob) {
        String strByte = xob.getText();
        byte[] encodedArray = strByte.getBytes();
        byte[] decodedArray = EncodeBase64.decode(encodedArray);
        return decodedArray;
    }

    private Object readCharArray(char[] a, Element xob) {
        StringTokenizer st = new StringTokenizer(xob.getText());
        int index = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int decimalValue = SimpleReader.getDecimalValue(s);
            a[index++] = (char)decimalValue;
        }
        return a;
    }

    private Object readCharArray(Character[] a, Element xob) {
        StringTokenizer st = new StringTokenizer(xob.getText());
        int index = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("null")) {
                a[index++] = null;
                continue;
            }
            int decimalValue = SimpleReader.getDecimalValue(s);
            a[index++] = new Character((char)decimalValue);
        }
        return a;
    }

    private Object readClassArray(Class[] a, Element xob) {
        StringTokenizer st = new StringTokenizer(xob.getText());
        int index = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("null")) {
                a[index++] = null;
                continue;
            }
            Class javaClass = (Class)mapWOXToJava.get(s);
            if (javaClass == null) {
                javaClass = (Class)mapArrayWOXToJava.get(s);
                if (javaClass == null) {
                    try {
                        a[index++] = Class.forName(s);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                a[index++] = javaClass;
                continue;
            }
            a[index++] = javaClass;
        }
        return a;
    }

    private Object readHashMap(Element xob, Object id) {
        System.out.println("Reading a HashMap...");
        HashMap<Object, Object> newHashMap = new HashMap<Object, Object>();
        List children = xob.getChildren();
        boolean index = false;
        for (Element entryElement : children) {
            List entryChildren = entryElement.getChildren();
            Object key = this.read((Element)entryChildren.get(0));
            Object value = this.read((Element)entryChildren.get(1));
            newHashMap.put(key, value);
        }
        this.map.put(id, newHashMap);
        return newHashMap;
    }

    private Object readArrayList(Element xob, Object id) {
        Object array = this.readObjectArrayGeneric(xob, id);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            list.add(Array.get(array, i));
        }
        this.map.put(id, list);
        return list;
    }

    private Object readObjectArray(Element xob, Object id) {
        Object array = this.readObjectArrayGeneric(xob, id);
        this.map.put(id, array);
        return array;
    }

    private Object readObjectArrayGeneric(Element xob, Object id) {
        try {
            String arrayTypeName = xob.getAttributeValue("elementType");
            int len = Integer.parseInt(xob.getAttributeValue("length"));
            Class componentType = this.getObjectArrayComponentType(arrayTypeName);
            Object array = Array.newInstance(componentType, len);
            List children = xob.getChildren();
            int index = 0;
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Object childArray = this.read((Element)i.next());
                Array.set(array, index++, childArray);
            }
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Class getObjectArrayComponentType(String arrayTypeName) throws Exception {
        Class javaClass = (Class)mapWOXToJava.get(arrayTypeName);
        if (javaClass == null) {
            javaClass = (Class)mapArrayWOXToJava.get(arrayTypeName);
            if (javaClass == null) {
                if (arrayTypeName.equals("Object")) {
                    arrayTypeName = "java.lang.Object";
                }
                return Class.forName(arrayTypeName);
            }
            return javaClass;
        }
        return javaClass;
    }

    private Object readStringObject(Element xob, Object id) {
        try {
            Class type = (Class)TypeMapping.mapWOXToJava.get(xob.getAttributeValue("type"));
            if (type.equals(Class.class)) {
                Class javaClass = (Class)mapWOXToJava.get(xob.getAttributeValue("value"));
                if (javaClass == null) {
                    javaClass = (Class)mapArrayWOXToJava.get(xob.getAttributeValue("value"));
                    if (javaClass == null) {
                        Class<?> obClass = Class.forName(xob.getAttributeValue("value"));
                        this.map.put(id, obClass);
                        return obClass;
                    }
                    this.map.put(id, javaClass);
                    return javaClass;
                }
                this.map.put(id, javaClass);
                return javaClass;
            }
            if (type.equals(Character.TYPE)) {
                int decimalValue = SimpleReader.getDecimalValue(xob.getAttributeValue("value"));
                Character charObject = new Character((char)decimalValue);
                this.map.put(id, charObject);
                return charObject;
            }
            Object ob = this.makeWrapper(type, xob.getAttributeValue("value"));
            this.map.put(id, ob);
            return ob;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getDecimalValue(String unicodeValue) {
        String unicodeModified = unicodeValue.substring(2, unicodeValue.length());
        int decimalValue = Integer.parseInt(unicodeModified, 16);
        return decimalValue;
    }

    private Object readObject(Element xob, Object id) {
        try {
            Class<?> type = Class.forName(xob.getAttributeValue("type"));
            Constructor cons = Util.forceDefaultConstructor(type);
            cons.setAccessible(true);
            Object ob = this.makeObject(cons, new Object[0], id);
            boolean bbb = ob instanceof Method;
            this.setFields(ob, xob);
            return ob;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            return null;
        }
    }

    private void setFields(Object ob, Element xob) {
        Class<?> type = ob.getClass();
        for (Element fe : xob.getChildren()) {
            String name = fe.getAttributeValue("name");
            String declaredType = fe.getAttributeValue("declaredClass");
            try {
                Class<?> declaringType = declaredType != null ? Class.forName(declaredType) : type;
                Field field = this.getField(declaringType, name);
                field.setAccessible(true);
                Object value = null;
                if (Util.primitive(field.getType())) {
                    if (fe.getAttributeValue("type").equals("char")) {
                        int decimalValue = SimpleReader.getDecimalValue(fe.getAttributeValue("value"));
                        Character charObject = new Character((char)decimalValue);
                        value = charObject;
                    } else {
                        value = this.makeWrapper(field.getType(), fe.getAttributeValue("value"));
                    }
                } else if (mapWOXToJava.get(fe.getAttributeValue("type")) != null) {
                    Class typeWrapper = (Class)TypeMapping.mapWOXToJava.get(fe.getAttributeValue("type"));
                    if (typeWrapper.equals(Character.class)) {
                        int decimalValue = SimpleReader.getDecimalValue(fe.getAttributeValue("value"));
                        Character charObject = new Character((char)decimalValue);
                        value = charObject;
                    } else {
                        Class[] st = new Class[]{String.class};
                        Constructor cons = typeWrapper.getDeclaredConstructor(st);
                        cons.setAccessible(true);
                        value = cons.newInstance(fe.getAttributeValue("value"));
                    }
                } else {
                    Element child = (Element)fe.getChildren().iterator().next();
                    value = this.read(child);
                }
                field.set(ob, value);
            }
            catch (Exception e) {}
        }
    }

    private Object makeObject(Constructor cons, Object[] args, Object key) throws Exception {
        cons.setAccessible(true);
        Object value = cons.newInstance(args);
        this.map.put(key, value);
        return value;
    }

    private Object makeWrapper(Class type, String value) throws Exception {
        Class wrapperType = this.getWrapperType(type);
        Constructor cons = wrapperType.getDeclaredConstructor(String.class);
        return cons.newInstance(value);
    }

    private Field getField(Class type, String name) throws Exception {
        if (type == null) {
            return null;
        }
        try {
            return type.getDeclaredField(name);
        }
        catch (Exception e) {
            return this.getField(type.getSuperclass(), name);
        }
    }

    private void print(Constructor[] cons) {
        for (int i = 0; i < cons.length; ++i) {
        }
    }

    private Class getComponentType(String type) {
        for (int i = 0; i < primitiveArrays.length; ++i) {
            if (!primitiveArrays[i].getName().equals(type)) continue;
            return primitives[i];
        }
        return null;
    }

    private Class getArrayType(String type) {
        for (int i = 0; i < primitiveArrays.length; ++i) {
            if (!primitiveArrays[i].getName().equals(type)) continue;
            return primitiveArrays[i];
        }
        return null;
    }

    static {
        primitivesMap.put("float", Float.TYPE);
        primitivesMap.put("double", Double.TYPE);
        primitivesMap.put("boolean", Boolean.TYPE);
        primitivesMap.put("char", Character.TYPE);
        primitivesMap.put("int", Integer.TYPE);
        primitivesMap.put("short", Short.TYPE);
        primitivesMap.put("long", Long.TYPE);
        primitivesMap.put("byte", Byte.TYPE);
    }
}

